const toggleBtn = document.getElementById('toggle-theme');
toggleBtn.addEventListener('click', () => {
  document.body.classList.toggle('dark-mode');
});

// Animation sections khi cuộn đến
const sections = document.querySelectorAll('section');
const observer = new IntersectionObserver(entries => {
  entries.forEach(entry => {
    if(entry.isIntersecting) {
      entry.target.classList.add('show');
    }
  });
}, { threshold: 0.1 });

sections.forEach(section => observer.observe(section));

function animateBlinkingText(selector) {
  const element = document.querySelector(selector);
  if (!element) return;

  const text = element.textContent;
  element.textContent = '';

  const totalDuration = 2000; // 2 giây
  const interval = totalDuration / text.length;

  for (let i = 0; i < text.length; i++) {
    const span = document.createElement('span');
    span.textContent = text[i];
    span.style.animationDelay = (i * interval) + 'ms';
    element.appendChild(span);
  }

  element.classList.add('blinking');
}

animateBlinkingText('h1.blinking');

function isInViewport(element) {
  const rect = element.getBoundingClientRect();
  return (
    rect.top >= 0 &&
    rect.bottom <= (window.innerHeight || document.documentElement.clientHeight)
  );
}

function animateSkills() {
  const skillBars = document.querySelectorAll('.skill-bar');
  skillBars.forEach(bar => {
    if (isInViewport(bar) && !bar.classList.contains('animated')) {
      const percent = bar.getAttribute('data-percent');
      const innerBar = bar.querySelector('.bar');
      innerBar.style.width = percent + '%';
      bar.classList.add('animated');
    }
  });
}

window.addEventListener('scroll', animateSkills);
window.addEventListener('load', animateSkills);
window.addEventListener('scroll', function () {
    const nav = document.querySelector('nav');
    if (window.scrollY > 50) {
      nav.classList.add('scrolled');
    } else {
      nav.classList.remove('scrolled');
    }
  });

  window.addEventListener("scroll", function () {
  const scrollIndicator = document.getElementById("scroll-indicator");
  const scrollTop = window.scrollY;
  const maxHeight = document.body.scrollHeight - window.innerHeight;
  const scrollPercent = (scrollTop / maxHeight) * 100;
  scrollIndicator.style.width = scrollPercent + "%";
});


//  const carousel = document.querySelector('.carousel-3d');

//   let currentRotation = 0;
//   let isDragging = false;
//   let startX = 0;
//   let autoRotate = true;
//   let autoRotateSpeed = 0.2;
//   let autoRotateTimeout;

//   function animate() {
//     if (autoRotate && !isDragging) {
//       currentRotation += autoRotateSpeed;
//       carousel.style.transform = `rotateY(${currentRotation}deg)`;
//     }
//     requestAnimationFrame(animate);
//   }

//   animate(); // bắt đầu vòng xoay

//   // Dừng xoay khi bắt đầu kéo
//   carousel.addEventListener('mousedown', (e) => {
//     isDragging = true;
//     autoRotate = false;
//     startX = e.clientX;
//     carousel.style.transition = 'none';
//     if (autoRotateTimeout) clearTimeout(autoRotateTimeout);
//   });

//   // Xử lý kéo chuột
//   window.addEventListener('mousemove', (e) => {
//     if (!isDragging) return;
//     const deltaX = e.clientX - startX;
//     startX = e.clientX;
//     currentRotation += deltaX * 0.5; // điều chỉnh tốc độ xoay theo chuột
//     carousel.style.transform = `rotateY(${currentRotation}deg)`;
//   });

//   // Khi thả chuột, sau 2s quay lại tự động
//   window.addEventListener('mouseup', () => {
//     if (isDragging) {
//       isDragging = false;
//       carousel.style.transition = 'transform 0.5s';
//       autoRotateTimeout = setTimeout(() => {
//         autoRotate = true;
//       }, 2000); // delay quay lại sau 2 giây
//     }
//   });
 const carousel = document.querySelector('.carousel-3d');

  let currentRotation = 0;
  let isDragging = false;
  let startX = 0;
  let autoRotate = true;
  let autoRotateSpeed = 0.1;
  let lastScrollY = window.scrollY;

  function animate() {
    if (autoRotate && !isDragging) {
      currentRotation += autoRotateSpeed;
      updateRotation();
    }
    requestAnimationFrame(animate);
  }

  function updateRotation() {
    carousel.style.transform = `rotateY(${currentRotation}deg)`;
  }

  // Kéo chuột
  carousel.addEventListener('mousedown', (e) => {
    isDragging = true;
    autoRotate = false;
    startX = e.clientX;
  });

  window.addEventListener('mousemove', (e) => {
    if (!isDragging) return;
    const deltaX = e.clientX - startX;
    startX = e.clientX;
    currentRotation += deltaX * 0.4;
    updateRotation();
  });

  window.addEventListener('mouseup', () => {
    if (isDragging) {
      isDragging = false;
      autoRotate = true;
    }
  });

  // Cuộn trang để đổi chiều xoay
  window.addEventListener('scroll', () => {
    const currentScrollY = window.scrollY;

    // So sánh với vị trí cuộn trước đó
    if (currentScrollY > lastScrollY) {
      autoRotateSpeed = Math.abs(autoRotateSpeed); // cuộn xuống → xoay thuận
    } else if (currentScrollY < lastScrollY) {
      autoRotateSpeed = -Math.abs(autoRotateSpeed); // cuộn lên → xoay ngược
    }

    lastScrollY = currentScrollY;
  });

  animate(); // bắt đầu xoay

  // thoi gian

  function updateClock() {
    const now = new Date();
    const time = now.toLocaleTimeString();
    const date = now.toLocaleDateString(undefined, { weekday: 'short', year: 'numeric', month: 'short', day: 'numeric' });
    document.getElementById('clock-time').textContent = time;
    document.getElementById('clock-date').textContent = date;
  }
  setInterval(updateClock, 1000);
  updateClock(); // lần đầu

//   particlesJS("particles-js", {
//     particles: {
//       number: {
//         value: 60,
//         density: {
//           enable: true,
//           value_area: 800
//         }
//       },
//       color: {
//         value: "#ffffff"
//       },
//       shape: {
//         type: "circle"
//       },
//       opacity: {
//         value: 0.5
//       },
//       size: {
//         value: 3
//       },
//       line_linked: {
//         enable: true,
//         distance: 150,
//         color: "#ffffff",
//         opacity: 0.4,
//         width: 1
//       },
//       move: {
//         enable: true,
//         speed: 2,
//         direction: "none",
//         out_mode: "out"
//       }
//     },
//     interactivity: {
//       events: {
//         onhover: {
//           enable: true,
//           mode: "repulse"
//         },
//         onclick: {
//           enable: true,
//           mode: "push"
//         }
//       },
//       modes: {
//         repulse: {
//           distance: 100
//         },
//         push: {
//           particles_nb: 4
//         }
//       }
//     },
//     retina_detect: true
//   });
// color: window.matchMedia('(prefers-color-scheme: dark)').matches ? "#66d9ef" : "#007acc"




document.addEventListener("DOMContentLoaded", () => {
  const textElement = document.getElementById("animated-text");
  const text = textElement.textContent;
  textElement.textContent = ""; // Xóa text gốc

  // Lặp từng ký tự, tạo span chứa mỗi ký tự và delay animation theo index
  text.split("").forEach((char, index) => {
    const span = document.createElement("span");
    span.textContent = char === " " ? "\u00A0" : char; // giữ khoảng trắng
    span.style.animationDelay = `${index * 0.008}s`; // delay tăng dần theo chữ
    textElement.appendChild(span);
  });
});
// document.addEventListener("DOMContentLoaded", () => {
//   const list = document.getElementById("animated-projects");
//   if (!list) return;

//   // Duyệt từng li
//   list.querySelectorAll("li").forEach((li, liIndex) => {
//     const text = li.textContent;
//     li.textContent = ""; // Xóa nội dung cũ

//     // Tạo từng span cho mỗi chữ
//     text.split("").forEach((char, charIndex) => {
//       const span = document.createElement("span");
//       span.textContent = char === " " ? "\u00A0" : char;
//       // Delay tính theo vị trí chữ, có thể thêm offset cho từng dòng
//       span.style.animationDelay = `${(liIndex * 0.5) + (charIndex * 0.02)}s`;
//       li.appendChild(span);
//     });
//   });
// });
